<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class acc_sub extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_acc_sub');				
	}

	public function index(){
		if(!fcek_hak_akses('.AO0.')) {
			redirect('forbidden');
		}
		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_sub/v_acc_sub_list', $data);
		$this->load->view('v_footer');			
	}

	public function acc_sub_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_sub');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['acc_sub_list'] = $this->m_acc_sub->get_acc_sub_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['acc_sub_list']);
		}
		else {
			$pagination['total_list'] = $this->m_acc_sub->get_acc_sub_list($arr_filter, true);
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['acc_sub_list'] = $this->load->view('data_master/acc_sub/v_acc_sub_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function acc_sub_new(){	
		if(!fcek_hak_akses('.AO1.')) {
			redirect('forbidden');
		}

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_sub/v_acc_sub_form',$data);
		$this->load->view('v_footer');			
	}

	public function acc_sub_view($msas_no = null){
		if(!fcek_hak_akses('.AO0.')) {
			redirect('forbidden');
		}

		if (is_null($msas_no) || count($this->m_acc_sub->get_acc_sub($msas_no)) <= 0) {
			redirect('acc_sub');
			return;
		}
		$data = array();
		$data['action'] = 'view';				
		$data['acc_sub'] = $this->m_acc_sub->get_acc_sub($msas_no);	
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_sub/v_acc_sub_form',$data);
		$this->load->view('v_footer');														
	}

	public function acc_sub_new_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_sub');

		$result = array();					 
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$msas_no = $this->input->post('msag_no'). ".". $this->input->post('msas_no');		
			if($this->m_acc_sub->get_acc_subno($msas_no) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('msas_no' => 'Account Subgroup ID: '.$msas_no.' is already registered. Please input Account Subgroup ID.');
				echo json_encode($result);	
			}else if($this->m_acc_sub->get_acc_subnm(null, fhapus_kutip($this->input->post('msas_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Account Subgroup name already exists');
				echo json_encode($result);			
			}else{							
				$data = array();			
				$data['msas_no'] = $msas_no;
				$data['msas_nm'] = fhapus_kutip($this->input->post('msas_nm'));							
				$data['msas_listmscb'] = (($this->input->post('msas_listmscb') != '') ? ".". implode('.', $this->input->post('msas_listmscb')). "." : '');
				$data['msas_salnorm'] = fhapus_kutip($this->input->post('msas_salnorm'));
				$data['msas_aktif'] = 1; //(($this->input->post('msas_aktif') == 'on') ? 1 : 0);			
				$data['msas_lsupd'] = date('Y-m-d H:i:s');
				$data['msas_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_acc_sub->acc_sub_new_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['msas_no'] = $data['msas_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
		}				        
	}

	public function acc_sub_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_sub');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['msas_listmscb'] = (($this->input->post('msas_listmscb') != '') ? ".". implode('.', $this->input->post('msas_listmscb')). "." : '');			
			$data_status['msag_no'] = $this->input->post('msag_no');
			if(fcek_status($data_status)){
				$result['response'] = 'gagal';
				$result['error_message'] = array('fail'=>'Can not save [OFF] status');
				echo json_encode($result);		     	
			}else if($this->m_acc_sub->get_acc_subnm($this->input->post('msag_no'). '.'. $this->input->post('msas_no'), fhapus_kutip($this->input->post('msas_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Account Subgroup name already exists');
				echo json_encode($result);			
			}else{			     	
				$data = array();
				$data['msas_no'] = $data_status['msag_no']. ".".$this->input->post('msas_no');
				$data['msas_nm'] = fhapus_kutip($this->input->post('msas_nm'));			
				$data['msas_listmscb'] = $data_status['msas_listmscb'];
				$data['msas_salnorm'] = fhapus_kutip($this->input->post('msas_salnorm'));
				//$data['msas_aktif'] = (($this->input->post('msas_aktif') == 'on') ? 1 : 0);			
				$data['msas_lsupd'] = date('Y-m-d H:i:s');
				$data['msas_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];
									
				if($this->m_acc_sub->acc_sub_edit_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');			
					$result['response'] = 'sukses';				
		  	 		$result['msas_no'] = $data['msas_no'];			
		  	 		echo json_encode($result);
				}				
			}	
		}				        
	}

	public function get_acc_sub(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_sub');

		echo json_encode($this->m_acc_sub->get_all_acc_sub());				
	}

	public function acc_sub_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_sub');

		$data['msas_no'] = $this->input->post('msas_no');
		$data['msas_aktif'] = $this->input->post('msas_aktif');

		if($this->m_acc_sub->acc_sub_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msas_no'] = $data['msas_no'];			
  	 		echo json_encode($result);
		}
	}

	public function acc_sub_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_sub');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';

		$respon = array();
		$respon['popup'] = $this->load->view('data_master/acc_sub/v_acc_sub_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function acc_sub_autocomplete(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_sub');

		$keyword = $this->input->post('query');
		if (strpos($keyword, '-') !== FALSE) {
			$keyword = substr($keyword, 0, 6);
		}		
		$data_acc_sub = $this->m_acc_sub->get_acc_sub_autocomplete($keyword);
		foreach ($data_acc_sub as $key => $value) {
			$data_acc_sub[$key]['value'] = $value['msas_nm'];			
		}
		$data_acc_sub['suggestions'] = $data_acc_sub;
		echo json_encode($data_acc_sub);
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msag_no',
		                'label' => 'Account Group ID',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msas_no',
		                'label' => 'Account Subgroup ID',
		                'rules' => 'required|min_length[2]',
		                'errors' => array(
		                        'required' => ' Please input %s. '		      
		                )
		        ),		        
		        array(
		                'field' => 'msas_nm',
		                'label' => 'Account Subgroup Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msas_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}	

}