<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class acc_group extends MY_Controller {

	function __construct(){
		parent::__construct();
		$this->load->model('data_master/m_acc_group');				
	}

	public function index(){
		if(!fcek_hak_akses('.AN0.')){
			redirect('forbidden');
		}
		$data = array();
		$data['per_page'] = 15;
		$data['request_from'] = 'list';					
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_group/v_acc_group_list', $data);
		$this->load->view('v_footer');			
	}

	public function acc_group_list(){			
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_group');

		$data = array();
		$result = array();
		$pagination = array();

		$arr_filter = array();		
		$arr_filter = $this->input->post('arr_filter');			
		$per_page = ($arr_filter['nlimit'] > 0) ? $arr_filter['nlimit'] : $this->input->post('per_page');				
		$offset = $this->input->post('offset');
		$curr_page = $this->input->post('curr_page');		
		$fn = $this->input->post('fn');
		$sort = $this->input->post('sort');		

		$data['acc_group_list'] = $this->m_acc_group->get_acc_group_list($arr_filter, false, $per_page, $offset, $fn, $sort);

		$pagination['per_page'] = $per_page;
		$pagination['curr_page'] = $curr_page;		

		if ($arr_filter['nlimit'] > 0) {
			$pagination['total_list'] = count($data['acc_group_list']);
		}
		else {
			$pagination['total_list'] = $this->m_acc_group->get_acc_group_list($arr_filter, true);		
		}
		
		$pagination['fn'] = $fn;
		$pagination['sort'] = $sort;

		$result['acc_group_list'] = $this->load->view('data_master/acc_group/v_acc_group_datalist',$data,true);
		$result['pagination'] = $this->load->view('v_pagination',$pagination,true);		
		$result['total_list'] = $pagination['total_list'];
		
		echo json_encode($result);
	}
	
	public function acc_group_new(){			
		if(!fcek_hak_akses('.AN1.')){
			redirect('forbidden');
		}					

		$data = array();
		$data['action'] = 'new';
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_group/v_acc_group_form',$data);
		$this->load->view('v_footer');		
	}

	public function acc_group_view($msag_no){
		if(!fcek_hak_akses('.AN0.')){
			redirect('forbidden');
		}			

		if (is_null($msag_no) || count($this->m_acc_group->get_acc_group($msag_no)) <= 0) {
			redirect('acc_group');
			return;
		}	
		$data = array();
		$data['action'] = 'view';				
		$data['acc_group'] = $this->m_acc_group->get_acc_group($msag_no);
		$data['key'] = uniqid();
		$data['hash_key'] = fenkripsi($data['key']);	
		if($this->session->userdata('svlogin') == 'F'){
			$this->load->view('v_navigation_f');
		}else{
			$this->load->view('v_navigation');
		}
		$this->load->view('data_master/acc_group/v_acc_group_form',$data);
		$this->load->view('v_footer');		
	}

	public function acc_group_new_simpan(){	
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_group');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{		
			if($this->m_acc_group->get_acc_groupno($this->input->post('msag_no')) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('msag_no' => 'Account Group ID: '.$this->input->post('msag_no').' is already registered. Please input Account Group ID.');
				echo json_encode($result);	
			}else if($this->m_acc_group->get_acc_groupname(null, fhapus_kutip($this->input->post('msag_nm'))) > 0){
				$result['response'] = 'gagal';
				$result['error_message'] = array('error'=>'Account Group Name already exists');
				echo json_encode($result);			
			}else{			
				$data = array();				

				$data['msag_no'] = $this->input->post('msag_no');
				$data['msag_nm'] = fhapus_kutip($this->input->post('msag_nm'));			
				$data['msag_listmscb'] = (($this->input->post('msag_listmscb') != '') ? ".". implode('.', $this->input->post('msag_listmscb')). "." : '');
				$data['msag_jenis'] = fhapus_kutip($this->input->post('msag_jenis'));
				$data['msag_salnorm'] = fhapus_kutip($this->input->post('msag_salnorm'));				
				$data['msag_kelompok'] = fhapus_kutip($this->input->post('msag_kelompok'));			
				$data['msag_aktif'] = 1; //(($this->input->post('msag_aktif') == 'on') ? 1 : 0);
				$data['msag_lsupd'] = date('Y-m-d H:i:s');
				$data['msag_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

				if($this->m_acc_group->acc_group_simpan($data)){
					$this->session->set_userdata('alert_sukses','sukses');
					$result['response'] = 'sukses';				
		  	 		$result['msag_no'] = $data['msag_no'];	      	 		
		  	 		echo json_encode($result);
				}			
			}	
		}				        
	}


	public function acc_group_edit_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_group');

		$result = array();
		$this->form_validation->set_rules($this->config_validation());

		if($this->form_validation->run() == FALSE){
			$result['response'] = 'gagal';
			$result['error_message'] = $this->form_validation->error_array();
			echo json_encode($result);
		}else{
			$data_status['msag_listmscb'] = (($this->input->post('msag_listmscb') != '') ? ".". implode('.', $this->input->post('msag_listmscb')). "." : '');			
			if(fcek_status($data_status)){
					$result['response'] = 'gagal';
					$result['error_message'] = array('fail'=>'Can not save [OFF] status');
					echo json_encode($result);		     	
			}else if($this->m_acc_group->get_acc_groupname($this->input->post('msag_no'), fhapus_kutip($this->input->post('msag_nm'))) > 0){
					$result['response'] = 'gagal';
					$result['error_message'] = array('error'=>'Account Group Name already exists');
					echo json_encode($result);			
			}else{
					$data = array();		     		
					$data['msag_no'] = $this->input->post('msag_no');
					$data['msag_nm'] = fhapus_kutip($this->input->post('msag_nm'));			
					$data['msag_listmscb'] = $data_status['msag_listmscb'];					
					//$data['msag_jenis'] = $this->input->post('msag_jenis');
					//$data['msag_salnorm'] = $this->input->post('msag_salnorm');
					//$data['msag_aktif'] = (($this->input->post('msag_aktif') == 'on') ? 1 : 0);
					
					$data['msag_kelompok'] = fhapus_kutip($this->input->post('msag_kelompok'));
					$data['msag_lsupd'] = date('Y-m-d H:i:s');
					$data['msag_lsusr'] = $this->session->userdata('user_aktif')['msus_no'];

					if($this->m_acc_group->acc_group_edit_simpan($data)){	
						$this->session->set_userdata('alert_sukses','sukses');		
						$result['response'] = 'sukses';				
			  	 		$result['msag_no'] = $data['msag_no'];			
			  	 		echo json_encode($result);
					}				
			}	
		}				        
	}


	public function get_acc_group(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_group');
						
		echo json_encode($this->m_acc_group->get_all_acc_group());				
	}

	public function get_acc_group_byid(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_group');

		$msag_no = $this->input->post('msag_no');
						
		echo json_encode($this->m_acc_group->get_acc_group($msag_no));				
	}

	public function acc_group_aktif_simpan(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_group');

		$data['msag_no'] = $this->input->post('msag_no');
		$data['msag_aktif'] = $this->input->post('msag_aktif');

		if($this->m_acc_group->acc_group_aktif_simpan($data)){
			$this->session->set_userdata('alert_sukses','sukses');			
			$result['response'] = 'sukses';				
  	 		$result['msag_no'] = $data['msag_no'];			
  	 		echo json_encode($result);
		}
	}

	public function acc_group_popup(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_group');

		$data = array();
		$data['per_page'] = 13;
		$data['request_from'] = 'popup';

		$respon = array();
		$respon['popup'] = $this->load->view('data_master/acc_group/v_acc_group_popup',$data,true);	
		echo json_encode($respon);		
	}

	public function acc_group_autocomplete(){
		$key = $this->input->post('key');
		$hash_key = $this->input->post('hash_key');
		fcek_direct_access($key, $hash_key, 'acc_group');

		$keyword = $this->input->post('query');
		if (strpos($keyword, '-') !== FALSE) {
			$keyword = substr($keyword, 0, 6);
		}		
		$data_acc_group = $this->m_acc_group->get_acc_group_autocomplete($keyword);
		foreach ($data_acc_group as $key => $value) {
			$data_acc_group[$key]['value'] = $value['msag_nm'];			
		}
		$data_acc_group['suggestions'] = $data_acc_group;
		echo json_encode($data_acc_group);
	}

	private function config_validation(){
		$config = array(
		        array(
		                'field' => 'msag_no',
		                'label' => 'Account Group ID',
		                'rules' => 'required|min_length[2]',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'msag_nm',
		                'label' => 'Account Group Name',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),
		        array(
		                'field' => 'msag_kelompok',
		                'label' => 'Kelompok',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please input %s. '
		                )
		        ),		        
		        array(
		                'field' => 'msag_listmscb[]',
		                'label' => 'Area',
		                'rules' => 'required',
		                'errors' => array(
		                        'required' => ' Please select %s. '
		                )
		        )

		);
		return $config;
	}
}