<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code


/*
|--------------------------------------------------------------------------
| Simrel Constant
|--------------------------------------------------------------------------
|
*/

define('CONS_SIMREL_APPVER','16.10.06');
define('CONS_SIMREL_DBVER',318);

define('HA_DATAMASTER','.AA0.|.AB0.|.AC0.|.AD0.|.AE0.|.AF0.|.AG0.|.AH0.|.AI0.|.AJ0.|.AK0.|.AL0.|.AM0.|.AN0.|.AO0.|.AP0.|.AQ0.|.AR0.|.AS0.|.AT0.|.HB7.|.HB8.');
define('HA_DATAMASTER_CUSTOMER','.AA0.');
define('HA_DATAMASTER_SUPPLIER','.AB0.');
define('HA_DATAMASTER_PRODUK','.AC0.|.AD0.|.AE0.|.AF0.|.AG0.');
define('HA_DATAMASTER_ITEM','.AC0.');
define('HA_DATAMASTER_KATEGORI','.AD0.');
define('HA_DATAMASTER_FAMILI','.AE0.');
define('HA_DATAMASTER_MODEL','.AF0.');
define('HA_DATAMASTER_MERK','.AG0.');
define('HA_DATAMASTER_PERUSAHAAN','.AH0.|.AI0.|.AJ0.|.AK0.|.AL0.');
define('HA_DATAMASTER_CABANG','.AH0.');
define('HA_DATAMASTER_GUDANG','.AI0.'); 
define('HA_DATAMASTER_SALES','.AJ0.');
define('HA_DATAMASTER_USER','.AK0.'); 
define('HA_DATAMASTER_USERGROUP','.AL0.');
define('HA_DATAMASTER_FINANCEANDACC','.AM0.|.AN0.|.AO0.|.AP0.'); 
define('HA_DATAMASTER_JENISBAYAR','.AM0.'); 
define('HA_DATAMASTER_COSTCENTER','.AU0.'); 
define('HA_DATAMASTER_ACCGROUP','.AN0.'); 
define('HA_DATAMASTER_ACCSUB','.AO0.'); 
define('HA_DATAMASTER_ACCPER','.AP0.');
define('HA_DATAMASTER_PAKETPRODUK','.AQ0.');
define('HA_DATAMASTER_MTDPENYUSUTAN','.AR0.');
define('HA_DATAMASTER_TIPEAKTIVATETAP','.AS0.');
define('HA_DATAMASTER_AKTIVATETAP','.AT0.');

define('HA_PURCHASING','.BA0.|.BB0.|.BC0.|.BD0.|.BE0.|.HB7.|.HB8.');
define('HA_PURCHASING_PURCHASEREQUEST','.BA0.');
define('HA_PURCHASING_APPROVALPR','.BB0.');
define('HA_PURCHASING_PURCHASEORDER','.BC0.');
define('HA_PURCHASING_INCOMINGDELIVERY','.BD0.');
define('HA_PURCHASING_PURCHASERETURN','.BE0.');

define('HA_SALES','.CA0.|.CB0.|.CC0.|.HB7.|.HB8.');
define('HA_SALES_SALESINQUERY','.CA0.');
define('HA_SALES_SALESORDER','.CB0.');
define('HA_SALES_SALESRETURN','.CC0.');

define('HA_STOCKCONTROL','.DA0.|.DB0.|.DC0.|.DD0.|.DE0.|.DF0.|.DG0.|.HB7.|.HB8.');
define('HA_STOCKCONTROL_INVENTORY','.DA0.');
// define('HA_STOCKCONTROL_RECEIVINGGOODS','.DB0.');
define('HA_STOCKCONTROL_SALESDELIVERY','.DB0.');
define('HA_STOCKCONTROL_STOCKMUTATION','.DC0.');
define('HA_STOCKCONTROL_STOCKADJUSTMENT','.DD0.');
define('HA_STOCKCONTROL_GOODSTRANSFORMATION','.DE0.');
define('HA_STOCKCONTROL_INVENTORYPERAREA','.DF0.');
define('HA_STOCKCONTROL_GOODSCONVERTION','.DG0.');

define('HA_FAC','.EB0.|.EC0.|.ED0.|.EE0.');
define('HA_FAC_JOURNAL','.EB0.');
define('HA_FAC_SOPAYMENT','.EC0.');
define('HA_FAC_POPAYMENT','.ED0.');
define('HA_FAC_PERBULANAN','.EE0.');
define('HA_FAC_REKON','.EF0.');
define('HA_FAC_GIROMASUK','.EG0.');
define('HA_FAC_TRANSFERMASUK','.EH0.');
define('HA_FAC_GIROKELUAR','.EI0.');
define('HA_FAC_TRANSFERKELUAR','.EJ0.');

define('HA_SETTING','.FA0.|.FB0.|.FC0.|.FD0.|.FE0.|.FF0.|.FG0.|.FH0.');
define('HA_SETTING_CURRENCYRATES','.FA0.');
define('HA_SETTING_EFAKTUR','.FH0.');
define('HA_SETTING_ACCOUNT','.FB0.');
define('HA_SETTING_USERLOG','.FC0.');
define('HA_SETTING_JOURNALINFO','.FD0.');
define('HA_SETTING_SOPRINTNOTES','.FE0.');
define('HA_SETTING_AUTOSETHPP','.FF0.');
define('HA_UPDATE_HISTORY','.FG0.');

define('HA_SPK','.GA0.|.GB0.|.HB7.|.HB8.');
define('HA_SPK_FORM','.GA0.');
define('HA_SPK_VISIT','.GB0.');

define('HA_REPORTING','.HA0.');
define('HA_TIPE_TRANS_F','.HB7.');
define('HA_TIPE_TRANS_C','.HB8.');











